/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.drink;

import cloud.lemonslice.teastory.blockentity.TeaCupBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.ItemRegister;

public class WoodenTrayBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty DRINK = IntegerProperty.m_61631_((String)"drink", (int)0, (int)3);
    public static final IntegerProperty CUP = IntegerProperty.m_61631_((String)"cup", (int)0, (int)3);
    private static final VoxelShape TRAY = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    private static final VoxelShape WITH_CUP = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 6.0, 16.0);

    public WoodenTrayBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if ((Integer)pState.m_61143_((Property)CUP) > 0) {
            return WITH_CUP;
        }
        return TRAY;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{CUP, DRINK}));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack held = player.m_21120_(handIn);
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TeaCupBlockEntity) {
            if (held.m_41619_()) {
                int index = (Integer)state.m_61143_((Property)CUP) - 1;
                if (index > -1) {
                    ItemStack itemStack = this.getCup((TeaCupBlockEntity)te, index);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemStack);
                    if (itemStack.m_41720_() == ItemRegister.PORCELAIN_CUP.get()) {
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)CUP, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)CUP) - 1)));
                    } else {
                        worldIn.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CUP, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)CUP) - 1))).m_61124_((Property)DRINK, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DRINK) - 1)));
                    }
                }
            } else {
                int index = (Integer)state.m_61143_((Property)CUP);
                if (!this.setCup((TeaCupBlockEntity)te, index, held, worldIn, pos, state) && held.m_41720_() == BlockEntityRegister.PORCELAIN_TEAPOT.get()) {
                    FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_21120_(handIn), (int)1)).ifPresent(item -> {
                        for (int i = 0; i < 3; ++i) {
                            FluidTank tank = ((TeaCupBlockEntity)te).getFluidTank(i);
                            if (!tank.isEmpty()) continue;
                            if (!FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)tank)) break;
                            if ((Integer)state.m_61143_((Property)DRINK) + 1 <= 3) {
                                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)DRINK, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DRINK) + 1)));
                            }
                            worldIn.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 0.5f, 0.9f);
                            break;
                        }
                    });
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean setCup(TeaCupBlockEntity te, int index, ItemStack itemStack, Level world, BlockPos pos, BlockState state) {
        if (index >= 3) {
            return false;
        }
        if (itemStack.m_41720_() == ItemRegister.PORCELAIN_CUP_DRINK.get() || itemStack.m_41720_() == ItemRegister.PORCELAIN_CUP.get()) {
            FluidStack stack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
            if (!stack.isEmpty()) {
                if ((Integer)state.m_61143_((Property)DRINK) + 1 <= 3) {
                    world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CUP, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)CUP) + 1))).m_61124_((Property)DRINK, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DRINK) + 1)));
                    world.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 0.5f, 0.9f);
                }
            } else {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)CUP, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)CUP) + 1)));
                world.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 0.5f, 0.9f);
            }
            te.setFluidTank(index, stack);
            itemStack.m_41774_(1);
            return true;
        }
        return false;
    }

    public ItemStack getCup(TeaCupBlockEntity te, int index) {
        if (index > 3) {
            return ItemStack.f_41583_;
        }
        FluidStack fluidStack = te.getFluidTank(index).getFluidInTank(0);
        if (fluidStack.isEmpty()) {
            return new ItemStack((ItemLike)ItemRegister.PORCELAIN_CUP.get());
        }
        ItemStack itemStack = new ItemStack((ItemLike)ItemRegister.PORCELAIN_CUP_DRINK.get());
        CompoundTag fluidTag = new CompoundTag();
        fluidStack.writeToNBT(fluidTag);
        itemStack.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
        return itemStack;
    }

    public void m_6810_(BlockState state, Level pLevel, BlockPos pos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity tileEntity;
        if (!pNewState.m_60713_((Block)this) && (tileEntity = pLevel.m_7702_(pos)) instanceof TeaCupBlockEntity) {
            for (int i = 0; i < 3; ++i) {
                if (pLevel.m_5776_() || (Integer)state.m_61143_((Property)CUP) <= i) continue;
                Block.m_49840_((Level)pLevel, (BlockPos)pos, (ItemStack)this.getCup((TeaCupBlockEntity)tileEntity, i));
            }
        }
        super.m_6810_(state, pLevel, pos, pNewState, pMovedByPiston);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityRegister.WOODEN_TRAY_TYPE.get()).m_155264_(blockPos, blockState);
    }
}

